use master
GO

set nocount on 

declare @ProjectPayload01 nvarchar(max) = N'
-- 2420 DEV-91923
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[sp_GetAppendedInterviewers]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[sp_GetAppendedInterviewers]
'

declare @ProjectPayload02 nvarchar(max) = N'
-- This stored procedure requires #Interviewers table to be created by the caller
CREATE PROCEDURE [dbo].[sp_GetAppendedInterviewers]
    @projectId INT,
	@unknownAgent NVARCHAR(19)
AS
BEGIN
    SET NOCOUNT ON;

    INSERT INTO #Interviewers
    SELECT DISTINCT
        H.[HisInterviewer] AS [ID], 
        CASE
            WHEN H.[HisInterviewer] IN (N''***'', N''PD*'')
                THEN H.[HisInterviewer]
            WHEN LTRIM(RTRIM(ISNULL(rch.[Name], '''')))
                + LTRIM(RTRIM(ISNULL(TA.[FirstName], '''')))
                + LTRIM(RTRIM(ISNULL(TA.[LastName],''''))) <> ''''
                THEN ''('' + LTRIM(RTRIM(ISNULL(rch.[Name], ''''))) + '') ''
                + LTRIM(RTRIM(ISNULL(TA.[FirstName], ''''))) + '' ''
                + LTRIM(RTRIM(ISNULL(TA.[LastName], ''''))) 
            WHEN I.[IntName] IS NOT NULL
                THEN I.[IntName]
                ELSE H.[HisInterviewer] + N'' '' + @unknownAgent
        END AS [Name], 
        0 AS [NodeNotEmpty],
		0 AS [Status],
		0 AS [ItemType],
		@projectId AS [ParentID]
    FROM (
	    SELECT DISTINCT [HisInterviewer]
	    FROM [dbo].[Historic] WITH(NOLOCK)
	    WHERE [HisInterviewer] <> N''***''
	) H 
    LEFT JOIN [dbo].[tblObjects] rch WITH(NOLOCK) ON rch.[k_Id] = H.[HisInterviewer]
    LEFT JOIN [dbo].[tblAgents] TA WITH(NOLOCK) ON TA.[k_id] = CASE WHEN ISNUMERIC(H.[HisInterviewer]) <> 0
        THEN H.[HisInterviewer]
        ELSE -1
        END 
    LEFT JOIN [dbo].[Interviewer] I WITH(NOLOCK) ON I.[IntInitiale] = H.[HisInterviewer] 
    WHERE NOT EXISTS (
	    SELECT 1
		FROM #Interviewers i WITH(NOLOCK)
		WHERE i.[ID] = H.[HisInterviewer]
	);
END
'

declare @ProjectPayload03 nvarchar(max) = N'
-- 2421  DEV-91815
IF NOT EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[StratumModifLog]'') AND type IN (N''U''))
BEGIN
	CREATE TABLE [dbo].[StratumModifLog]
	(
		[Id] INT IDENTITY(1, 1) NOT NULL,
		[Respondent] NVARCHAR(10) NOT NULL,
		[QuotaId] INT NOT NULL,
		[OldStratum] INT NULL,
		[Stratum] INT NULL,
		[OldIncrementValue] INT NULL,
		[IncrementValue] INT NULL,
		[AppName] NVARCHAR(128) NOT NULL,
		[DateTime] DATETIME NOT NULL,
		CONSTRAINT [PK_StratumModifLog] PRIMARY KEY CLUSTERED ([Id])
	);
END
'

declare @ProjectPayload04 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.triggers WHERE object_id = OBJECT_ID(N''[dbo].[VX_TR_StratumModifLog_Delete]''))
   DROP TRIGGER [dbo].[VX_TR_StratumModifLog_Delete]
'

declare @ProjectPayload05 nvarchar(max) = N'
CREATE TRIGGER [dbo].[VX_TR_StratumModifLog_Delete]
	ON [dbo].[Stratum]
	AFTER DELETE
AS
BEGIN
	SET NOCOUNT ON;
	INSERT INTO [dbo].[StratumModifLog] (
		[Respondent],
		[QuotaId],
		[OldStratum],
		[Stratum],
		[OldIncrementValue],
		[IncrementValue],
		[AppName],
		[DateTime]
	)
	SELECT
		deleted.[StrRespondent],
		deleted.[StrQuotaId],
		deleted.[StrStratum],
		NULL,
		deleted.[IncrementValue],
		NULL,
		APP_NAME(),
		GETUTCDATE()
	FROM deleted;
END
'

declare @ProjectPayload06 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.triggers WHERE object_id = OBJECT_ID(N''[dbo].[VX_TR_StratumModifLog_Insert]''))
   DROP TRIGGER [dbo].[VX_TR_StratumModifLog_Insert]
'

declare @ProjectPayload07 nvarchar(max) = N'
CREATE TRIGGER [dbo].[VX_TR_StratumModifLog_Insert]
	ON [dbo].[Stratum]
	AFTER INSERT
AS
BEGIN
	SET NOCOUNT ON;
	INSERT INTO [dbo].[StratumModifLog] (
		[Respondent],
		[QuotaId],
		[OldStratum],
		[Stratum],
		[OldIncrementValue],
		[IncrementValue],
		[AppName],
		[DateTime]
	)
	SELECT
		inserted.[StrRespondent],
		inserted.[StrQuotaId],
		NULL,
		inserted.[StrStratum],
		NULL,
		inserted.[IncrementValue],
		APP_NAME(),
		GETUTCDATE()
	FROM inserted;
END
'

declare @ProjectPayload08 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.triggers WHERE object_id = OBJECT_ID(N''[dbo].[VX_TR_StratumModifLog_Update]''))
   DROP TRIGGER [dbo].[VX_TR_StratumModifLog_Update]
'

declare @ProjectPayload09 nvarchar(max) = N'
CREATE TRIGGER [dbo].[VX_TR_StratumModifLog_Update]
	ON [dbo].[Stratum]
	AFTER UPDATE
AS
BEGIN
	SET NOCOUNT ON;
	IF (UPDATE([StrStratum]) OR UPDATE([IncrementValue]))
	BEGIN
		INSERT INTO [dbo].[StratumModifLog] (
			[Respondent],
			[QuotaId],
			[OldStratum],
			[Stratum],
			[OldIncrementValue],
			[IncrementValue],
			[AppName],
			[DateTime]
		)
		SELECT
			inserted.[StrRespondent],
			inserted.[StrQuotaId],
			deleted.[StrStratum],
			inserted.[StrStratum],
			deleted.[IncrementValue],
			inserted.[IncrementValue],
			APP_NAME(),
			GETUTCDATE()
		FROM inserted
		INNER JOIN deleted
			ON inserted.[StrRespondent] = deleted.[StrRespondent]
			AND inserted.[StrQuotaId] = deleted.[StrQuotaId]
		WHERE inserted.[StrStratum] <> deleted.[StrStratum]
			OR inserted.[IncrementValue] <> deleted.[IncrementValue];
	END
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @TotalProjectsDB int,
        @ThisProjectsDB nvarchar(128),
		@ProjectsDBCounter int = 0, 
		@ProjectsDBCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

		
insert into #DB 
SELECT [name] AS DBName, 0 AS Processed FROM sys.databases WHERE [name] like 'VOXCO_Project_%';
	     
select @TotalProjectsDB = count(*) 
	    from #DB
	
set @ProjectsDBCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
open @ProjectsDBCursor
fetch next from @ProjectsDBCursor into @ThisProjectsDB
while @@FETCH_STATUS = 0 begin
	select @ProjectsDBCounter += 1
	select @DBSQL = @ThisProjectsDB + N'.sys.sp_executesql'
	select @StatusMessage = 'Updating Project database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ProjectsDBCounter / @TotalProjectsDB
	raiserror (@StatusMessage, 0, 1, @ThisProjectsDB, @ProjectsDBCounter, @TotalProjectsDB, @StatusPercent) with nowait
	
	SELECT 'Updating Project DB: ' + @ThisProjectsDB
        print 'Project Payload 1'
        if isnull(@ProjectPayload01, '') <> '' exec @DBSQL @ProjectPayload01

        print 'Project Payload 2'
        if isnull(@ProjectPayload02, '') <> '' exec @DBSQL @ProjectPayload02

        print 'Project Payload 3'
        if isnull(@ProjectPayload03, '') <> '' exec @DBSQL @ProjectPayload03

        print 'Project Payload 4'
        if isnull(@ProjectPayload04, '') <> '' exec @DBSQL @ProjectPayload03

        print 'Project Payload 5'
        if isnull(@ProjectPayload05, '') <> '' exec @DBSQL @ProjectPayload03

        print 'Project Payload 6'
        if isnull(@ProjectPayload06, '') <> '' exec @DBSQL @ProjectPayload03

        print 'Project Payload 7'
        if isnull(@ProjectPayload07, '') <> '' exec @DBSQL @ProjectPayload03

        print 'Project Payload 8'
        if isnull(@ProjectPayload08, '') <> '' exec @DBSQL @ProjectPayload03

        print 'Project Payload 9'
        if isnull(@ProjectPayload09, '') <> '' exec @DBSQL @ProjectPayload03

	print 'All Project Payload done!'

	update #DB set Processed = 1 where current of @ProjectsDBCursor
	fetch next from @ProjectsDBCursor into @ThisProjectsDB
end

close @ProjectsDBCursor
deallocate @ProjectsDBCursor

--select * from #DB

drop table #DB

